local t = LoadFallbackB();

-- Song Title/Artist Info
t[#t+1] = LoadFont("Common Normal") .. { 
          InitCommand=cmd(x,SCREEN_CENTER_X+150;y,SCREEN_CENTER_Y-5;maxwidth,SCREEN_WIDTH;horizalign,center;diffuse,color("#E6F7F9");strokecolor,Color("Outline");zoom,0.5;uppercase,true;maxwidth); 
		  OffCommand=cmd(accelerate,0.2;diffusealpha,0;);
          CurrentSongChangedMessageCommand=cmd(playcommand,"Set"); 
          CurrentCourseChangedMessageCommand=cmd(playcommand,"Set"); 
          ChangedLanguageDisplayMessageCommand=cmd(playcommand,"Set"); 
          SetCommand=function(self) 
               local song = GAMESTATE:GetCurrentSong(); 
               if song then
					self:smooth(0.2)
					self:diffusealpha(0);
                    self:settext(song:GetGenre()); 
                    self:playcommand("Refresh");
					(cmd(stoptweening;zoomx,0.4;diffusealpha,0.0;smooth,0.2;zoomx,0.5;diffusealpha,1))(self)
				else
					self:settext("");
					self:playcommand("Refresh"); 	
               end 
          end;
};

t[#t+1] = LoadFont("_exo2 semi bold 24px") .. { 
          InitCommand=cmd(x,SCREEN_CENTER_X+150;y,SCREEN_CENTER_Y+12;maxwidth,300;horizalign,center;horizalign,center;diffuse,color("#FFFFFF");strokecolor,Color("Outline");zoom,0.8;); 
          CurrentSongChangedMessageCommand=cmd(playcommand,"Set"); 
          CurrentCourseChangedMessageCommand=cmd(playcommand,"Set"); 
          ChangedLanguageDisplayMessageCommand=cmd(playcommand,"Set"); 
		  OffCommand=cmd(accelerate,0.2;diffusealpha,0;);
          SetCommand=function(self) 
               local song = GAMESTATE:GetCurrentSong() or GAMESTATE:GetCurrentCourse(); 
               if song then
			   		self:smooth(0.2)
					self:diffusealpha(0);
                    self:settext(song:GetDisplayFullTitle()); 
                    self:playcommand("Refresh");
					(cmd(stoptweening;zoomx,0.7;diffusealpha,0.0;smooth,0.2;zoomx,0.8;diffusealpha,1))(self)
				else
					self:settext("");
					self:playcommand("Refresh"); 	
               end 
          end; 
};

t[#t+1] = LoadFont("Common Normal") .. { 
          InitCommand=cmd(x,SCREEN_CENTER_X+150;y,SCREEN_CENTER_Y+30;horizalign,center;diffuse,color("#E6F7F9");strokecolor,Color("Outline");zoom,0.6;); 
		  OffCommand=cmd(accelerate,0.2;diffusealpha,0;);
          CurrentSongChangedMessageCommand=cmd(playcommand,"Set"); 
          CurrentCourseChangedMessageCommand=cmd(playcommand,"Set"); 
          ChangedLanguageDisplayMessageCommand=cmd(playcommand,"Set"); 
          SetCommand=function(self) 
               local song = GAMESTATE:GetCurrentSong(); 
               if song then 
			   		self:smooth(0.2)
					self:diffusealpha(0);
                    self:settext(song:GetDisplayArtist()); 
                    self:playcommand("Refresh");
					(cmd(stoptweening;zoomx,0.5;diffusealpha,0.0;smooth,0.2;zoomx,0.6;diffusealpha,1))(self)
				else
					self:settext("");
					self:playcommand("Refresh"); 	
               end 
          end;
};


t[#t+1] = LoadActor("_panel") .. {
		InitCommand=cmd(horizalign,center;x,SCREEN_CENTER_X+120;y,SCREEN_BOTTOM-123;visible,not GAMESTATE:IsCourseMode(););
		OnCommand=cmd(diffusealpha,0;zoomx,1.2;zoomy,1.1;smooth,0.2;zoomx,1.0;zoomy,1.0;diffusealpha,1;);
		OffCommand=cmd(sleep,0.2;smooth,0.2;zoomx,1.2;diffusealpha,0;);
	};
	
t[#t+1] = LoadActor("_course") .. {
		InitCommand=cmd(horizalign,center;x,SCREEN_CENTER_X;y,SCREEN_BOTTOM-123;visible,GAMESTATE:IsCourseMode(););
		OnCommand=cmd(diffusealpha,0;zoomx,1.2;zoomy,1.1;smooth,0.2;zoomx,1.0;zoomy,1.0;diffusealpha,1;);
		OffCommand=cmd(sleep,0.2;smooth,0.2;zoomx,1.2;diffusealpha,0;);
	};


t[#t+1] = StandardDecorationFromFileOptional("DifficultyList","DifficultyList");
t[#t+1] = StandardDecorationFromFileOptional("BPMDisplay","BPMDisplay");

t[#t+1] = StandardDecorationFromFileOptional("SortOrder","SortOrderText") .. {
	BeginCommand=cmd(uppercase,true;playcommand,"Set");
	SortOrderChangedMessageCommand=cmd(playcommand,"Set";);
	SetCommand=function(self)
		local s = SortOrderToLocalizedString( GAMESTATE:GetSortOrder() );
		self:settext( s );
		self:playcommand("Sort");
	end;
};

return t